using System; 
using System.Diagnostics;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Data.SqlClient;

namespace DataView {
    /// <summary>
    /// Summary description for Form1.
    /// </summary>
    public class Form1 : System.Windows.Forms.Form {
        private SqlConnection cn; 
        private SqlCommand cmd; 
        private SqlDataAdapter da;
        private DataSet ds; 
        private object objDb;

        internal System.Windows.Forms.TabControl TabControl1;
        internal System.Windows.Forms.TabPage TabPage1;
        internal System.Windows.Forms.TextBox txtFilter;
        internal System.Windows.Forms.Label Label1;
        internal System.Windows.Forms.TabPage TabPage2;
        internal System.Windows.Forms.TextBox txtGeneralFilter;
        internal System.Windows.Forms.Button btnGeneralFilter;
        internal System.Windows.Forms.Label Label3;
        internal System.Windows.Forms.TabPage TabPage4;
        internal System.Windows.Forms.ComboBox cmbFields;
        internal System.Windows.Forms.TextBox txtFilterColumn;
        internal System.Windows.Forms.Label Label4;
        internal System.Windows.Forms.TabPage TabPage3;
        internal System.Windows.Forms.RadioButton rbDsc;
        internal System.Windows.Forms.Button btnSort;
        internal System.Windows.Forms.RadioButton rbAsc;
        internal System.Windows.Forms.Label Label2;
        internal System.Windows.Forms.ComboBox cmbSortArg;
        internal System.Windows.Forms.DataGrid DataGrid1;
        internal System.Windows.Forms.TextBox txtQYearLow;
        internal System.Windows.Forms.Button btnQuery;
        internal System.Windows.Forms.TextBox txtQYearHigh;
        internal System.Windows.Forms.TextBox txtQTitle;
        internal System.Windows.Forms.Button btnFilterTitle;
        internal System.Windows.Forms.Button btnFilteronColumn;
        /// <summary>
        /// Required designer variable.
        /// </summary>
        private System.ComponentModel.Container components = null;

        public Form1() {
            try {
                //
                // Required for Windows Form Designer support
                //
                InitializeComponent();

                //
                // TODO: Add any constructor code after InitializeComponent call
                //

                cn = new SqlConnection("server=.;database=biblio;uid=admin;pwd=pw");
                cmd = new SqlCommand("GetTitlesByYear",cn);
                cmd.CommandType = CommandType.StoredProcedure;
                cmd.Parameters.Add("@TitleWanted", SqlDbType.VarChar, 20);
                cmd.Parameters.Add("@YearLow", SqlDbType.Int);
                cmd.Parameters.Add("@YearHigh", SqlDbType.Int);

                da = new SqlDataAdapter(cmd);
                ds = new DataSet();

                RunQuery();
                txtFilter.Text = txtQTitle.Text;
            }
            catch (Exception ex) {
                MessageBox.Show(ex.ToString());
                Console.WriteLine();
            }

        }


        private void FillSortCriteria() {
            try {
                if (cmbSortArg.Items.Count > 0) {
                    return;
                }
                foreach( DataColumn dc in ds.Tables[0].Columns) {
                    cmbSortArg.Items.Add(dc.Caption);
                    cmbFields.Items.Add(dc.Caption);
                }
            } 
            catch (Exception ex) {
                MessageBox.Show(ex.ToString());
                Console.WriteLine();
            }
        }

        private void RunQuery() {
            try{
                // Run query based on current parameter settings
                da.Fill(ds, "Titles");
                objDb = DataGrid1.DataSource;
                DataGrid1.DataSource = ds.Tables[0];
                FillSortCriteria();
            }
            catch (Exception ex) {
                Debug.WriteLine(ex.ToString());
                MessageBox.Show(ex.ToString());
            }
        }

        private void SetFilter(string strFilterExpression) {
            try {
                DataGrid1.DataSource = objDb;

                ds.Tables[0].DefaultView.RowFilter = strFilterExpression;
                if ( ds.Tables[0].DefaultView.Count > 0 ) {
                    DataGrid1.DataSource = ds.Tables[0].DefaultView;
                }
                else {
                    MessageBox.Show("No titles meet criteria.");
                }
            }
            catch (Exception ex) {
                MessageBox.Show(ex.ToString());
                Console.WriteLine();
            }
        }

        /// <summary>
        /// Clean up any resources being used.
        /// </summary>
        protected override void Dispose( bool disposing ) {
            if( disposing ) {
                if (components != null) {
                    components.Dispose();
                }
            }
            base.Dispose( disposing );
        }

		#region Windows Form Designer generated code
        /// <summary>
        /// Required method for Designer support - do not modify
        /// the contents of this method with the code editor.
        /// </summary>
        private void InitializeComponent() {
            this.TabControl1 = new System.Windows.Forms.TabControl();
            this.TabPage1 = new System.Windows.Forms.TabPage();
            this.txtFilter = new System.Windows.Forms.TextBox();
            this.btnFilterTitle = new System.Windows.Forms.Button();
            this.Label1 = new System.Windows.Forms.Label();
            this.TabPage2 = new System.Windows.Forms.TabPage();
            this.txtGeneralFilter = new System.Windows.Forms.TextBox();
            this.btnGeneralFilter = new System.Windows.Forms.Button();
            this.Label3 = new System.Windows.Forms.Label();
            this.TabPage4 = new System.Windows.Forms.TabPage();
            this.cmbFields = new System.Windows.Forms.ComboBox();
            this.txtFilterColumn = new System.Windows.Forms.TextBox();
            this.btnFilteronColumn = new System.Windows.Forms.Button();
            this.Label4 = new System.Windows.Forms.Label();
            this.TabPage3 = new System.Windows.Forms.TabPage();
            this.rbDsc = new System.Windows.Forms.RadioButton();
            this.btnSort = new System.Windows.Forms.Button();
            this.rbAsc = new System.Windows.Forms.RadioButton();
            this.Label2 = new System.Windows.Forms.Label();
            this.cmbSortArg = new System.Windows.Forms.ComboBox();
            this.DataGrid1 = new System.Windows.Forms.DataGrid();
            this.txtQYearLow = new System.Windows.Forms.TextBox();
            this.btnQuery = new System.Windows.Forms.Button();
            this.txtQYearHigh = new System.Windows.Forms.TextBox();
            this.txtQTitle = new System.Windows.Forms.TextBox();
            this.TabControl1.SuspendLayout();
            this.TabPage1.SuspendLayout();
            this.TabPage2.SuspendLayout();
            this.TabPage4.SuspendLayout();
            this.TabPage3.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.DataGrid1)).BeginInit();
            this.SuspendLayout();
            // 
            // TabControl1
            // 
            this.TabControl1.Controls.AddRange(new System.Windows.Forms.Control[] {
                                                                                      this.TabPage1,
                                                                                      this.TabPage2,
                                                                                      this.TabPage4,
                                                                                      this.TabPage3});
            this.TabControl1.Location = new System.Drawing.Point(8, 80);
            this.TabControl1.Name = "TabControl1";
            this.TabControl1.SelectedIndex = 0;
            this.TabControl1.Size = new System.Drawing.Size(520, 120);
            this.TabControl1.TabIndex = 17;
            // 
            // TabPage1
            // 
            this.TabPage1.Controls.AddRange(new System.Windows.Forms.Control[] {
                                                                                   this.txtFilter,
                                                                                   this.btnFilterTitle,
                                                                                   this.Label1});
            this.TabPage1.Location = new System.Drawing.Point(4, 22);
            this.TabPage1.Name = "TabPage1";
            this.TabPage1.Size = new System.Drawing.Size(512, 94);
            this.TabPage1.TabIndex = 0;
            this.TabPage1.Text = "Filter on Title";
            // 
            // txtFilter
            // 
            this.txtFilter.Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
            this.txtFilter.Location = new System.Drawing.Point(120, 24);
            this.txtFilter.Name = "txtFilter";
            this.txtFilter.Size = new System.Drawing.Size(368, 22);
            this.txtFilter.TabIndex = 1;
            this.txtFilter.Text = "";
            // 
            // btnFilterTitle
            // 
            this.btnFilterTitle.Location = new System.Drawing.Point(192, 56);
            this.btnFilterTitle.Name = "btnFilterTitle";
            this.btnFilterTitle.Size = new System.Drawing.Size(96, 24);
            this.btnFilterTitle.TabIndex = 2;
            this.btnFilterTitle.Text = "Filter Title";
            this.btnFilterTitle.Click += new System.EventHandler(this.btnFilterTitle_Click);
            // 
            // Label1
            // 
            this.Label1.Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
            this.Label1.Location = new System.Drawing.Point(16, 16);
            this.Label1.Name = "Label1";
            this.Label1.Size = new System.Drawing.Size(88, 32);
            this.Label1.TabIndex = 7;
            this.Label1.Text = "Filter expression...";
            this.Label1.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
            // 
            // TabPage2
            // 
            this.TabPage2.Controls.AddRange(new System.Windows.Forms.Control[] {
                                                                                   this.txtGeneralFilter,
                                                                                   this.btnGeneralFilter,
                                                                                   this.Label3});
            this.TabPage2.Location = new System.Drawing.Point(4, 22);
            this.TabPage2.Name = "TabPage2";
            this.TabPage2.Size = new System.Drawing.Size(512, 94);
            this.TabPage2.TabIndex = 1;
            this.TabPage2.Text = "General Filter";
            this.TabPage2.Visible = false;
            // 
            // txtGeneralFilter
            // 
            this.txtGeneralFilter.Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
            this.txtGeneralFilter.Location = new System.Drawing.Point(112, 24);
            this.txtGeneralFilter.Name = "txtGeneralFilter";
            this.txtGeneralFilter.Size = new System.Drawing.Size(376, 22);
            this.txtGeneralFilter.TabIndex = 1;
            this.txtGeneralFilter.Text = "ISBN = \'1-5561590-6-4\'";
            // 
            // btnGeneralFilter
            // 
            this.btnGeneralFilter.Location = new System.Drawing.Point(192, 56);
            this.btnGeneralFilter.Name = "btnGeneralFilter";
            this.btnGeneralFilter.Size = new System.Drawing.Size(96, 24);
            this.btnGeneralFilter.TabIndex = 2;
            this.btnGeneralFilter.Text = "Filter";
            this.btnGeneralFilter.Click += new System.EventHandler(this.btnGeneralFilter_Click);
            // 
            // Label3
            // 
            this.Label3.Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
            this.Label3.Location = new System.Drawing.Point(16, 24);
            this.Label3.Name = "Label3";
            this.Label3.Size = new System.Drawing.Size(88, 24);
            this.Label3.TabIndex = 7;
            this.Label3.Text = "Filter criteria";
            this.Label3.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
            // 
            // TabPage4
            // 
            this.TabPage4.Controls.AddRange(new System.Windows.Forms.Control[] {
                                                                                   this.cmbFields,
                                                                                   this.txtFilterColumn,
                                                                                   this.btnFilteronColumn,
                                                                                   this.Label4});
            this.TabPage4.Location = new System.Drawing.Point(4, 22);
            this.TabPage4.Name = "TabPage4";
            this.TabPage4.Size = new System.Drawing.Size(512, 94);
            this.TabPage4.TabIndex = 3;
            this.TabPage4.Text = "Filter on Column";
            this.TabPage4.Visible = false;
            // 
            // cmbFields
            // 
            this.cmbFields.DropDownWidth = 144;
            this.cmbFields.Location = new System.Drawing.Point(136, 24);
            this.cmbFields.Name = "cmbFields";
            this.cmbFields.Size = new System.Drawing.Size(144, 21);
            this.cmbFields.TabIndex = 8;
            // 
            // txtFilterColumn
            // 
            this.txtFilterColumn.Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
            this.txtFilterColumn.Location = new System.Drawing.Point(288, 24);
            this.txtFilterColumn.Name = "txtFilterColumn";
            this.txtFilterColumn.Size = new System.Drawing.Size(200, 22);
            this.txtFilterColumn.TabIndex = 1;
            this.txtFilterColumn.Text = "";
            // 
            // btnFilteronColumn
            // 
            this.btnFilteronColumn.Location = new System.Drawing.Point(192, 56);
            this.btnFilteronColumn.Name = "btnFilteronColumn";
            this.btnFilteronColumn.Size = new System.Drawing.Size(96, 24);
            this.btnFilteronColumn.TabIndex = 2;
            this.btnFilteronColumn.Text = "Filter Column";
            this.btnFilteronColumn.Click += new System.EventHandler(this.btnFilteronColumn_Click);
            // 
            // Label4
            // 
            this.Label4.Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
            this.Label4.Location = new System.Drawing.Point(8, 24);
            this.Label4.Name = "Label4";
            this.Label4.Size = new System.Drawing.Size(96, 32);
            this.Label4.TabIndex = 7;
            this.Label4.Text = "Filter expression";
            this.Label4.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
            // 
            // TabPage3
            // 
            this.TabPage3.Controls.AddRange(new System.Windows.Forms.Control[] {
                                                                                   this.rbDsc,
                                                                                   this.btnSort,
                                                                                   this.rbAsc,
                                                                                   this.Label2,
                                                                                   this.cmbSortArg});
            this.TabPage3.Location = new System.Drawing.Point(4, 22);
            this.TabPage3.Name = "TabPage3";
            this.TabPage3.Size = new System.Drawing.Size(512, 94);
            this.TabPage3.TabIndex = 2;
            this.TabPage3.Text = "Sort";
            this.TabPage3.Visible = false;
            // 
            // rbDsc
            // 
            this.rbDsc.Location = new System.Drawing.Point(400, 40);
            this.rbDsc.Name = "rbDsc";
            this.rbDsc.Size = new System.Drawing.Size(96, 16);
            this.rbDsc.TabIndex = 8;
            this.rbDsc.Text = "Descending";
            // 
            // btnSort
            // 
            this.btnSort.Location = new System.Drawing.Point(192, 56);
            this.btnSort.Name = "btnSort";
            this.btnSort.Size = new System.Drawing.Size(96, 24);
            this.btnSort.TabIndex = 2;
            this.btnSort.Text = "Sort";
            this.btnSort.Click += new System.EventHandler(this.btnSort_Click);
            // 
            // rbAsc
            // 
            this.rbAsc.Checked = true;
            this.rbAsc.Location = new System.Drawing.Point(400, 16);
            this.rbAsc.Name = "rbAsc";
            this.rbAsc.Size = new System.Drawing.Size(96, 16);
            this.rbAsc.TabIndex = 8;
            this.rbAsc.TabStop = true;
            this.rbAsc.Text = "Ascending";
            // 
            // Label2
            // 
            this.Label2.Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
            this.Label2.Location = new System.Drawing.Point(16, 24);
            this.Label2.Name = "Label2";
            this.Label2.Size = new System.Drawing.Size(88, 24);
            this.Label2.TabIndex = 7;
            this.Label2.Text = "Sort by...";
            this.Label2.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
            // 
            // cmbSortArg
            // 
            this.cmbSortArg.DropDownWidth = 176;
            this.cmbSortArg.Location = new System.Drawing.Point(112, 24);
            this.cmbSortArg.Name = "cmbSortArg";
            this.cmbSortArg.Size = new System.Drawing.Size(272, 21);
            this.cmbSortArg.TabIndex = 9;
            // 
            // DataGrid1
            // 
            this.DataGrid1.AlternatingBackColor = System.Drawing.Color.LightGray;
            this.DataGrid1.BackColor = System.Drawing.Color.DarkGray;
            this.DataGrid1.CaptionBackColor = System.Drawing.Color.White;
            this.DataGrid1.CaptionFont = new System.Drawing.Font("Verdana", 10F);
            this.DataGrid1.CaptionForeColor = System.Drawing.Color.Navy;
            this.DataGrid1.DataMember = "";
            this.DataGrid1.Dock = System.Windows.Forms.DockStyle.Bottom;
            this.DataGrid1.ForeColor = System.Drawing.Color.Black;
            this.DataGrid1.GridLineColor = System.Drawing.Color.Black;
            this.DataGrid1.GridLineStyle = System.Windows.Forms.DataGridLineStyle.None;
            this.DataGrid1.HeaderBackColor = System.Drawing.Color.Silver;
            this.DataGrid1.HeaderForeColor = System.Drawing.Color.Black;
            this.DataGrid1.LinkColor = System.Drawing.Color.Navy;
            this.DataGrid1.Location = new System.Drawing.Point(0, 205);
            this.DataGrid1.Name = "DataGrid1";
            this.DataGrid1.ParentRowsBackColor = System.Drawing.Color.White;
            this.DataGrid1.ParentRowsForeColor = System.Drawing.Color.Black;
            this.DataGrid1.SelectionBackColor = System.Drawing.Color.Navy;
            this.DataGrid1.SelectionForeColor = System.Drawing.Color.White;
            this.DataGrid1.Size = new System.Drawing.Size(536, 280);
            this.DataGrid1.TabIndex = 16;
            // 
            // txtQYearLow
            // 
            this.txtQYearLow.Location = new System.Drawing.Point(208, 48);
            this.txtQYearLow.Name = "txtQYearLow";
            this.txtQYearLow.Size = new System.Drawing.Size(104, 20);
            this.txtQYearLow.TabIndex = 15;
            this.txtQYearLow.Text = "1900";
            // 
            // btnQuery
            // 
            this.btnQuery.Location = new System.Drawing.Point(40, 32);
            this.btnQuery.Name = "btnQuery";
            this.btnQuery.Size = new System.Drawing.Size(96, 24);
            this.btnQuery.TabIndex = 13;
            this.btnQuery.Text = "Query";
            this.btnQuery.Click += new System.EventHandler(this.btnQuery_Click);
            // 
            // txtQYearHigh
            // 
            this.txtQYearHigh.Location = new System.Drawing.Point(328, 48);
            this.txtQYearHigh.Name = "txtQYearHigh";
            this.txtQYearHigh.Size = new System.Drawing.Size(104, 20);
            this.txtQYearHigh.TabIndex = 14;
            this.txtQYearHigh.Text = "1999";
            // 
            // txtQTitle
            // 
            this.txtQTitle.Location = new System.Drawing.Point(208, 16);
            this.txtQTitle.Name = "txtQTitle";
            this.txtQTitle.Size = new System.Drawing.Size(296, 20);
            this.txtQTitle.TabIndex = 12;
            this.txtQTitle.Text = "Hitch%";
            // 
            // Form1
            // 
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.ClientSize = new System.Drawing.Size(536, 485);
            this.Controls.AddRange(new System.Windows.Forms.Control[] {
                                                                          this.TabControl1,
                                                                          this.DataGrid1,
                                                                          this.txtQYearLow,
                                                                          this.btnQuery,
                                                                          this.txtQYearHigh,
                                                                          this.txtQTitle});
            this.Name = "Form1";
            this.Text = "Form1";
            this.TabControl1.ResumeLayout(false);
            this.TabPage1.ResumeLayout(false);
            this.TabPage2.ResumeLayout(false);
            this.TabPage4.ResumeLayout(false);
            this.TabPage3.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.DataGrid1)).EndInit();
            this.ResumeLayout(false);

        }
		#endregion

        /// <summary>
        /// The main entry point for the application.
        /// </summary>
        [STAThread]
        static void Main() {
            Application.Run(new Form1());
        }

        private void btnQuery_Click(object sender, System.EventArgs e) {
            try {
                ds.Clear();          // Remove any existing rowset from a previous query
                cmd.Parameters[0].Value = txtQTitle.Text;
                cmd.Parameters[1].Value = txtQYearLow.Text;
                cmd.Parameters["@YearHigh"].Value = txtQYearHigh.Text;
                txtFilter.Text = cmd.Parameters[0].Value.ToString();

                ds.Tables[0].DefaultView.RowFilter = "";
                RunQuery();
            }
            catch (Exception ex) {
                MessageBox.Show(ex.ToString());
                Console.WriteLine();
            }


        }

        private void btnSort_Click(object sender, System.EventArgs e) {
            try {
                string strSort;

                if (rbAsc.Checked) {
                    strSort = cmbSortArg.Text + " ASC";       // Note space after "
                }
                else {
                    strSort = cmbSortArg.Text + " DESC";     // Note space after "
                }
                ds.Tables[0].DefaultView.Sort = strSort;
                DataGrid1.DataSource = ds.Tables[0].DefaultView;
            }
            catch (Exception ex) {
                MessageBox.Show(ex.ToString());
                Console.WriteLine();
            }
            
        }



        private void btnFilterTitle_Click(object sender, System.EventArgs e) {
            try {
                SetFilter("Title like '" + txtFilter.Text + "'");
            }
            catch (Exception ex) {
                MessageBox.Show(ex.ToString());
                Console.WriteLine();
            }
        }

        private void btnGeneralFilter_Click(object sender, System.EventArgs e) {
            try {
                SetFilter(txtGeneralFilter.Text);
            }
            catch (Exception ex) {
                MessageBox.Show(ex.ToString());
                Console.WriteLine();
            }

        }

        private void btnFilteronColumn_Click(object sender, System.EventArgs e) {
            try {
                SetFilter(cmbFields.Text + " " + txtFilterColumn.Text);
            }
            catch (Exception ex) {
                MessageBox.Show(ex.ToString());
                Console.WriteLine();
            }
        }

    
    }
}
